<?php
/**
 * SwipeHQ Checkout extension for OpenCart 3.0.3.2+
 *
 * @version 3.0 / 18.02.202
 * @copyright (c) 2020, CyberCom.
 */

class ControllerExtensionPaymentSwipeHQ extends Controller {

    private $error = array();

    public function index() {

        $this->load->language('extension/payment/swipehq');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_setting_setting->editSetting('payment_swipehq', $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');
            $this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'].'&type=payment', 'SSL'));
        }

        $data['heading_title'] = $this->language->get('heading_title');
        $data['text_enabled'] = $this->language->get('text_enabled');
        $data['text_disabled'] = $this->language->get('text_disabled');
        $data['text_all_zones'] = $this->language->get('text_all_zones');
        $data['text_pay'] = $this->language->get('text_pay');
        $data['text_card'] = $this->language->get('text_card');

        $data['entry_merchant'] = $this->language->get('entry_merchant');
        $data['entry_api_key'] = $this->language->get('entry_api_key');
        $data['entry_api_url'] = $this->language->get('entry_api_url');
        $data['entry_payment_page_url'] = $this->language->get('entry_payment_page_url');

        $data['entry_total'] = $this->language->get('entry_total');
        $data['entry_order_status'] = $this->language->get('entry_order_status');
        $data['entry_failed_order_status'] = $this->language->get('entry_failed_order_status');
        $data['entry_test_mode'] = $this->language->get('entry_test_mode');
        $data['entry_test_order_status'] = $this->language->get('entry_test_order_status');
        $data['entry_debug_mode'] = $this->language->get('entry_debug_mode');
        $data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
        $data['entry_status'] = $this->language->get('entry_status');
        $data['entry_sort_order'] = $this->language->get('entry_sort_order');

        $data['button_save'] = $this->language->get('button_save');
        $data['button_cancel'] = $this->language->get('button_cancel');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['merchant'])) {
            $data['error_merchant'] = $this->error['merchant'];
        } else {
            $data['error_merchant'] = '';
        }

        if (isset($this->error['api_key'])) {
            $data['error_api_key'] = $this->error['api_key'];
        } else {
            $data['error_api_key'] = '';
        }

        if (isset($this->error['api_url'])) {
            $data['error_api_url'] = $this->error['api_url'];
        } else {
            $data['error_api_url'] = '';
        }

        if (isset($this->error['payment_page_url'])) {
            $data['error_payment_page_url'] = $this->error['payment_page_url'];
        } else {
            $data['error_payment_page_url'] = '';
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/home', 'user_token=' . $this->session->data['user_token'], 'SSL'),
            'separator' => false
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_payment'),
            'href' => $this->url->link('extension/payment', 'user_token=' . $this->session->data['user_token'], 'SSL'),
            'separator' => ' :: '
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('extension/payment/swipehq', 'user_token=' . $this->session->data['user_token'], 'SSL'),
            'separator' => ' :: '
        );

        $data['action'] = $this->url->link('extension/payment/swipehq', 'user_token=' . $this->session->data['user_token'], 'SSL');

        $data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'].'&type=payment', 'SSL');

        if (isset($this->request->post['payment_swipehq_merchant'])) {
            $data['payment_swipehq_merchant'] = $this->request->post['payment_swipehq_merchant'];
        } else {
            $data['payment_swipehq_merchant'] = $this->config->get('payment_swipehq_merchant');
        }

        if (isset($this->request->post['payment_swipehq_api_key'])) {
            $data['payment_swipehq_api_key'] = $this->request->post['payment_swipehq_api_key'];
        } else {
            $data['payment_swipehq_api_key'] = $this->config->get('payment_swipehq_api_key');
        }

        if (isset($this->request->post['payment_swipehq_api_url'])) {
            $data['payment_swipehq_api_url'] = $this->request->post['payment_swipehq_api_url'];
        } else {
            $data['payment_swipehq_api_url'] = $this->config->get('payment_swipehq_api_url');
        }

        if (isset($this->request->post['payment_swipehq_payment_page_url'])) {
            $data['payment_swipehq_payment_page_url'] = $this->request->post['payment_swipehq_payment_page_url'];
        } else {
            $data['payment_swipehq_payment_page_url'] = $this->config->get('payment_swipehq_payment_page_url');
        }

        if (isset($this->request->post['payment_swipehq_type'])) {
            $data['payment_swipehq_type'] = $this->request->post['payment_swipehq_type'];
        } else {
            $data['payment_swipehq_type'] = $this->config->get('payment_swipehq_type');
        }

        if (isset($this->request->post['payment_swipehq_total'])) {
            $data['payment_swipehq_total'] = $this->request->post['payment_swipehq_total'];
        } else {
            $data['payment_swipehq_total'] = $this->config->get('payment_swipehq_total');
        }

        $this->load->model('localisation/currency');

        $data['currencies'] = $this->model_localisation_currency->getCurrencies();
        // TODO: remove

        if (isset($this->request->post['payment_swipehq_order_status_id'])) {
            $data['payment_swipehq_order_status_id'] = $this->request->post['payment_swipehq_order_status_id'];
        } else {
            $data['payment_swipehq_order_status_id'] = $this->config->get('payment_swipehq_order_status_id');
        }

        if (isset($this->request->post['payment_swipehq_failed_order_status_id'])) {
            $data['payment_swipehq_failed_order_status_id'] = $this->request->post['payment_swipehq_failed_order_status_id'];
        } else {
            $data['payment_swipehq_failed_order_status_id'] = $this->config->get('payment_swipehq_failed_order_status_id');
        }

        if (isset($this->request->post['payment_swipehq_test_mode'])) {
            $data['payment_swipehq_test_mode'] = $this->request->post['payment_swipehq_test_mode'];
        } else {
            $data['payment_swipehq_test_mode'] = $this->config->get('payment_swipehq_test_mode');
        }

        if (isset($this->request->post['payment_swipehq_test_order_status_id'])) {
            $data['payment_swipehq_test_order_status_id'] = $this->request->post['payment_swipehq_test_order_status_id'];
        } else {
            $data['payment_swipehq_test_order_status_id'] = $this->config->get('payment_swipehq_test_order_status_id');
        }

        if (isset($this->request->post['payment_swipehq_debug_mode'])) {
            $data['payment_swipehq_debug_mode'] = $this->request->post['payment_swipehq_debug_mode'];
        } else {
            $data['payment_swipehq_debug_mode'] = $this->config->get('payment_swipehq_debug_mode');
        }

        $this->load->model('localisation/order_status');

        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        if (isset($this->request->post['payment_swipehq_geo_zone_id'])) {
            $data['payment_swipehq_geo_zone_id'] = $this->request->post['payment_swipehq_geo_zone_id'];
        } else {
            $data['payment_swipehq_geo_zone_id'] = $this->config->get('payment_swipehq_geo_zone_id');
        }

        $this->load->model('localisation/geo_zone');

        $data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

        if (isset($this->request->post['payment_swipehq_status'])) {
            $data['payment_swipehq_status'] = $this->request->post['payment_swipehq_status'];
        } else {
            $data['payment_swipehq_status'] = $this->config->get('payment_swipehq_status');
        }


        if (isset($this->request->post['payment_swipehq_sort_order'])) {
            $data['payment_swipehq_sort_order'] = $this->request->post['payment_swipehq_sort_order'];
        } else {
            $data['payment_swipehq_sort_order'] = $this->config->get('payment_swipehq_sort_order');
        }

            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->load->view('extension/payment/swipehq', $data));
    }

    private function validate() {
        if (!$this->user->hasPermission('modify', 'extension/payment/swipehq')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (!$this->request->post['payment_swipehq_merchant']) {
            $this->error['merchant'] = $this->language->get('error_merchant');
        }

        if (!$this->request->post['payment_swipehq_api_key']) {
            $this->error['api_key'] = $this->language->get('error_api_key');
        }

        if (!$this->error) {
            return true;
        } else {
            return false;
        }
    }

}

?>




